﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.BO.View
{
    public class StatisticCompetence : PI.FM.N000.Base.BL.BO.Base
    {
        public new class Search
        {
            public long? ClassID { get; set; }
            public long? StudentID { get; set; }
            public long? CompetenceID { get; set; }
        }

        public StatisticCompetence(Gemini.Core.BL.Interface.DBD.IDBDBase DBDBase)
            : base(DBDBase) { }

        public string Name
        {
            get { return GetValue<string>("Name"); }
            set { SetValue<string>("Name", value); }
        }

        public string Abbreviation
        {
            get { return GetValue<string>("Abbreviation"); }
            set { SetValue<string>("Abbreviation", value); }
        }
        public int? CompetencePointsByWeight
        {
            get { return GetValue<int?>("CompetencePointsByWeight"); }
            set { SetValue<int?>("CompetencePointsByWeight", value); }
        }
        public int? CompetenceMaxPoints
        {
            get { return GetValue<int?>("CompetenceMaxPoints"); }
            set { SetValue<int?>("CompetenceMaxPoints", value); }
        }
        public int? CaseStudyPoints
        {
            get { return GetValue<int?>("CaseStudyPoints"); }
            set { SetValue<int?>("CaseStudyPoints", value); }
        }
        public int? CaseStudyMaxPoints
        {
            get { return GetValue<int?>("CaseStudyMaxPoints"); }
            set { SetValue<int?>("CaseStudyMaxPoints", value); }
        }
        public decimal? Salary
        {
            get { return GetValue<decimal?>("Salary"); }
            set { SetValue<decimal?>("Salary", value); }
        }
        public int? ResetCount
        {
            get { return GetValue<int?>("ResetCount"); }
            set { SetValue<int?>("ResetCount", value); }
        }
        public int? CompetencePartDone
        {
            get { return GetValue<int?>("CompetencePartDone"); }
            set { SetValue<int?>("CompetencePartDone", value); }
        }

        public override string DisplayValue
        {
            get
            {
                return string.IsNullOrEmpty(Abbreviation) ? Name : Abbreviation;
            }
        }
        public int CaseStudyPointsPercent
        {
            get
            {
                return BasicUtility.PointPercent(CaseStudyPoints, CaseStudyMaxPoints);
            }
        }
        public int CompetencePointsPercent
        {
            get
            {
                return BasicUtility.PointPercent(CompetencePointsByWeight, CompetenceMaxPoints);
            }
        }
        public int SalaryValue
        {
            get
            {
                return Salary.HasValue ? Convert.ToInt32(Salary) : 0;
            }
        }
        public double CompetencePartDoneAvg
        {
            get
            { 
                if (CompetencePartDone.HasValue && ResetCount.HasValue && CompetencePartDone > 0)
                {
                    return Convert.ToDouble(ResetCount) / Convert.ToDouble(CompetencePartDone);
                }
                return 0;
            }
        }
    }
}